package com.liquidnet.service.kylin.controller.admin;

import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.kylin.dto.param.FieldsParam;
import com.liquidnet.service.kylin.dto.vo.FieldsVo;
import com.liquidnet.service.kylin.service.impl.FieldsServiceImpl;
import com.liquidnet.service.kylin.service.impl.admin.FieldsAdminServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api
@RestController
@RequestMapping("/admin/fields")
public class FieldsAdminController {

    @Autowired
    private FieldsAdminServiceImpl fieldsAdminService;

    @PostMapping(value = "")
    @ApiOperation(value = "创建场地")
    @ApiResponse(response = FieldsVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<FieldsVo> createFields(@RequestBody FieldsParam fieldsParam) {
        boolean result=fieldsAdminService.fieldCreate(fieldsParam);
        if(result) {
            return ResponseDto.success();
        }else{
            return ResponseDto.failure("场地创建失败");
        }
    }
}
