package com.liquidnet.service.reconciliation.strategy.funddata;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: 资金数据获取上下文
 * @class: GetFundDataStrategyContext
 * @Package com.liquidnet.service.reconciliation.strategy.transtype
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/27 14:35
 */
@Component
public class GetFundDataStrategyContext {
    private final Map<String, IGetFundDataStrategy> handlerMap = new HashMap<>();

    public IGetFundDataStrategy getStrategy(String type) {
        return handlerMap.get(type);
    }

    public void putStrategy(String code, IGetFundDataStrategy strategy) {
        handlerMap.put(code, strategy);
    }
}
