package com.liquidnet.service.goblin.enums;

/**
 * 订单状态枚举
 */

public enum OrderStatus {
    PENDING_PAYMENT(0, "待付款"),
    PAID(1, "已付款"),
    CLOSED(2, "已关闭"),
    REFUNDING(3, "正在退款"),
    REFUNDED(4, "已退款"),
    PENDING_CLOSE(5, "待关闭"),
    PARTIAL_REFUND(6, "部分退款");


    private final int code;
    private final String description;

    OrderStatus(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return code;
    }
    public String getDescription() {
        return description;
    }

    // 通过code获取对应的枚举值
    public static OrderStatus fromCode(int code) {
        for (OrderStatus status : values()) {
            if (status.getCode() == code) {
                return status;
            }
        }
        throw new IllegalArgumentException("无效的状态码: " + code);
    }
}
