package com.liquidnet.service.goblin.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class GoblinMixDetailsItemParam implements Serializable, Cloneable {
    @ApiModelProperty(value = "spuId")
    private String spuId;
    @ApiModelProperty(value = "skuId")
    private String skuId;
    @ApiModelProperty(value = "skuName")
    private String skuName;
    @ApiModelProperty(value = "商品类型[1-商城|2-数字藏品]")
    private String position;
    @ApiModelProperty(value = "原价")
    private BigDecimal skuPrice;
    @ApiModelProperty(value = "组合价格")
    private BigDecimal price;
    @ApiModelProperty(value = "苹果价格")
    private BigDecimal priceV;
    @ApiModelProperty(value = "苹果价格id")
    private String productId;
    @ApiModelProperty(value = "组合件数[数字藏品不能大于1]")
    private Integer count;

    private static final GoblinMixDetailsItemParam obj = new GoblinMixDetailsItemParam();

    public static GoblinMixDetailsItemParam getNew() {
        try {
            return (GoblinMixDetailsItemParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new GoblinMixDetailsItemParam();
    }
}
