package com.liquidnet.common.third.xuper.dto;

import com.alibaba.fastjson.JSONArray;
import lombok.Data;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 查询数字商品详情
 * @class: Xuper001GetStokenReqDto
 * @Package com.liquidnet.common.third.xuper.dto
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/18 15:10
 */
@Data
public class Xuper005QueryAssetRespDto {
    private long requestId;
    private int errNo;
    private String errMsg;
    private AssetMeta meta;

    @Data
    public static class AssetMeta {
        private long assetId;
        private int assetCate;
        private String title;
        private Thumb[] thumb;
        private String shortDesc;
        private String longDesc;
        private JSONArray imgDesc;
        private JSONArray assetUrl;
        private int amount;
        private long price;
        private int status;
        private String assetExt;
        private String createAddr;
        private long groupId;
        private String txId;
    }

    @Data
    public static class Thumb {
        private Urls urls;
        private String width;
        private String height;
    }

    @Data
    public static class Urls {
        private String icon;//60
        private String url1;//140
        private String url2;//360
        private String url3;//850
    }

    private static final Xuper005QueryAssetRespDto obj = new Xuper005QueryAssetRespDto();
    public static Xuper005QueryAssetRespDto getNew() {
        try {
            return (Xuper005QueryAssetRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Xuper005QueryAssetRespDto();
        }
    }
}
