package com.liquidnet.common.swagger.dto;

import com.liquidnet.common.swagger.annotation.ApiLevel;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 接口分级统计数据传输对象
 * 
 * @author system
 * @since 2024-10-29
 */
@Data
public class ApiLevelStatisticsDto {
    
    /**
     * 接口总数
     */
    private Integer totalCount;
    
    /**
     * 级别统计 (级别名称 -> 数量)
     */
    private Map<String, Integer> levelStatistics;

    /**
     * 按级别分组的接口列表 (级别名称 -> 接口信息列表)
     */
    private Map<String, List<ApiInfo>> apisByLevel;
    
    /**
     * 接口信息
     */
    @Data
    public static class ApiInfo {
        /**
         * 服务名称
         */
        private String serviceName;
        
        /**
         * 控制器名称
         */
        private String controllerName;
        
        /**
         * 方法名称
         */
        private String methodName;
        
        /**
         * 接口URL
         */
        private String url;
        
        /**
         * HTTP方法
         */
        private String httpMethod;
        
        /**
         * 接口级别
         */
        private ApiLevel.Level level;
        

        
        /**
         * 分级描述
         */
        private String description;
        
        /**
         * API描述
         */
        private String apiDescription;
    }
}