package com.liquidnet.common.swagger.dto;

import lombok.Data;

/**
 * 接口级别信息DTO
 * 
 * @author system
 * @since 2024-10-29
 */
@Data
public class ApiLevelInfoDto {
    
    /**
     * 级别代码 (L1, L2, L3, L4, L88, L99)
     */
    private String code;
    
    /**
     * 级别数值 (1, 2, 3, 4, 88, 99)
     */
    private Integer value;
    
    /**
     * 级别标签 (核心, 重要, 普通, 低级, 无需分级, 未配置)
     */
    private String label;
    
    /**
     * 级别详细描述
     */
    private String description;
    
    /**
     * 是否为未配置级别
     */
    private Boolean isUnconfigured;
    
    /**
     * 是否为无需分级级别
     */
    private Boolean isNoGrading;
    
    /**
     * 是否为业务级别 (L1-L4)
     */
    private Boolean isBusinessLevel;
}