package com.liquidnet.service.adam.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.adam.entity.AdamMember;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@ApiModel(value = "AdamMemberVo", description = "会员")
@Data
public class AdamMemberVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -3480288014645762321L;
    @ApiModelProperty(position = 0, value = "会员ID[50]")
    private String memberId;
    @ApiModelProperty(position = 1, value = "会员名称[50]", example = "摩登天空会员卡")
    private String name;
    @ApiModelProperty(position = 2, value = "会员标题[50]", example = "摩登天空会员卡")
    private String title;
    @ApiModelProperty(position = 3, value = "会员副标题[50]", example = "摩登天空会员卡副标题")
    private String subTitle;
    @ApiModelProperty(position = 4, value = "icon图标[200]", example = "https://img.zhengzai.tv/files/2020/08/28/5f490418d30b4.png")
    private String icon;
    @ApiModelProperty(position = 5, value = "会员头像[200]", example = "https://img.zhengzai.tv/files/2020/08/31/5f4c75095e9bc.png")
    private String avatar;
    @ApiModelProperty(position = 6, value = "起始编号", example = "10000")
    private Integer startNo;
    @ApiModelProperty(position = 7, value = "会员类型:1-VIP会员", example = "1")
    private Integer type;
    @ApiModelProperty(position = 6, value = "权益详情[200]", example = "加入摩登天空会员您可享受到.....")
    private String interestsDetail;
    @ApiModelProperty(position = 7, value = "注意事项[200]", example = "摩登天空会员需注意以下事项.....")
    private String notes;
    @ApiModelProperty(position = 8, value = "是否展示须知[200]", example = "0")
    private Integer isNotice;
    @ApiModelProperty(position = 9, value = "会员须知内容[200]", example = "会员须知细则1.xxxx\n2.xxxx")
    private String noticeInfo;
    @ApiModelProperty(position = 10, value = "会员须知标题[200]", example = "摩登天空会员须知")
    private String noticeTitle;
    @ApiModelProperty(position = 11, value = "是否需要答题[200]", example = "0")
    private Integer needQuestion;
    @ApiModelProperty(position = 12, value = "是否展示协议[200]", example = "0")
    private Integer displayAgreement;
    @ApiModelProperty(position = 13, value = "状态[1-NORMAL,2-INVALID]", example = "1")
    private Integer state;
    @ApiModelProperty(position = 14, value = "积分倍率", example = "2.00")
    private BigDecimal integralRate;
    @ApiModelProperty(position = 15, value = "是否开售:1-开售｜2-停售", example = "1")
    private Integer onsale;
    @ApiModelProperty(position = 16, value = "限购数量[0-不限购]", example = "0")
    private Integer limitation;
    @ApiModelProperty(position = 17, value = "限购开始时间", example = "2021-08-02 00:00:00")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime limitbAt;
    @ApiModelProperty(position = 18, value = "限购结束时间", example = "2021-09-02 00:00:00")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime limiteAt;

    @ApiModelProperty(position = 20, value = "会员卡价格信息")
    private List<AdamMemberPriceVo> priceVoList;
    @ApiModelProperty(position = 21, value = "会员专属权益")
    private List<AdamMemberRightsVo> rightsVoList;
    @ApiModelProperty(position = 22, value = "用户会员信息")
    private AdamUserMemberVo userMemberVo;
    @ApiModelProperty(position = 23, value = "购买会员限购[0-名额已满|1-允许购买｜2-限购未开始]")
    private Integer limitMarker;
    @ApiModelProperty(position = 24, value = "标记[0-普通用户｜2-过期会员｜10-老会员｜11-新会员]")
    private Integer stageMarker;

    public Integer getOnsale() {
        return null == onsale ? 1 : onsale;
    }

    /**
     * 购买会员限购[0-名额已满|1-允许购买|2-限购未开始]
     *
     * @param maxMemberLimitation 当前系统限购已购数量
     * @return [0-名额已满|1-允许购买]
     */
    public Integer calculateLimitMarker(int maxMemberLimitation) {
        if (null != this.limitation && this.limitation > 0) {// 限购
            if (maxMemberLimitation >= limitation) {// 名额已满
                this.setLimitMarker(0);
            } else if (null != this.limitbAt && null != this.limiteAt) {// 限购时间判断
                LocalDateTime now = LocalDateTime.now();
                boolean isBetweenLimitTime = now.isAfter(this.limitbAt) && now.isBefore(this.limiteAt);
                this.setLimitMarker(isBetweenLimitTime ? 1 : 2);
            } else {
                this.setLimitMarker(1);
            }
        } else {// 不限购
            this.setLimitMarker(1);
        }
        return this.limitMarker;
    }

    private static final AdamMemberVo obj = new AdamMemberVo();

    public static AdamMemberVo getNew() {
        try {
            return (AdamMemberVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamMemberVo();
    }

    public AdamMemberVo copy(AdamMember source) {
        if (null == this) return this;
        this.setMemberId(source.getMemberId());
        this.setName(source.getName());
        this.setTitle(source.getTitle());
        this.setSubTitle(source.getSubTitle());
        this.setIcon(source.getIcon());
        this.setAvatar(source.getAvatar());
        this.setStartNo(source.getStartNo());
        this.setType(source.getType());
        this.setInterestsDetail(source.getInterestsDetail());
        this.setNotes(source.getNotes());
        this.setIsNotice(source.getIsNotice());
        this.setNoticeInfo(source.getNoticeInfo());
        this.setNoticeTitle(source.getNoticeTitle());
        this.setNeedQuestion(source.getNeedQuestion());
        this.setDisplayAgreement(source.getDisplayAgreement());
        this.setState(source.getState());
        this.setIntegralRate(source.getIntegralRate());
        this.setOnsale(source.getOnsale());
        this.setLimitation(source.getLimitation());
        this.setLimitbAt(source.getLimitbAt());
        this.setLimiteAt(source.getLimiteAt());
        return this;
    }
}
