package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyNftPublishResultQueryRespDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/18 11:22
 */
@ApiModel(value = "GalaxyNftPublishResultQueryRespDto", description = "NFT发行结果查询")
@Data
public class GalaxyNftPublishResultQueryRespDto implements Serializable,Cloneable {
    /**
     * nftId格式，发行人公钥hash_系列_系列索引id,申请多少个，最后一段计算出来即可，
     * 比如申请10个，nftIdBegin位xx_xx_1,那么就可以推导出x_xx_1到x_xx_10
     */
    @ApiModelProperty(position = 3, required = true, value = "nftId格式")
    private String nftIdBegin;

    @ApiModelProperty(position = 3, required = true, value = "标记任务状态，0：任务执行中 1：任务成功 2：任务失败")
    private Integer taskStatus;

    /**
     * 失败情况下会有提示信息
     */
    @ApiModelProperty(position = 3, required = true, value = "失败情况下会有提示信息")
    private String taskMsg;

    /**
     * 交易hash
     */
    @ApiModelProperty(position = 3, required = true, value = "交易hash")
    private String txHash;

    /**
     * 链上交易时间戳
     */
    @ApiModelProperty(position = 3, required = true, value = "chainTimestamp")
    private String chainTimestamp;

    @Override
    public String toString() {
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftPublishResultQueryRespDto obj = new GalaxyNftPublishResultQueryRespDto();

    public static GalaxyNftPublishResultQueryRespDto getNew() {
        try {
            return (GalaxyNftPublishResultQueryRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftPublishResultQueryRespDto();
        }
    }
}
