package com.liquidnet.service.adam.service.processor;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.dto.vo.AdamTagVo;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.entity.AdamUser;
import com.liquidnet.service.adam.entity.AdamUserInfo;
import com.liquidnet.service.adam.mapper.AdamUserInfoMapper;
import com.liquidnet.service.adam.mapper.AdamUserMapper;
import com.liquidnet.service.adam.service.DataMigrationProcessorService;
import com.mysql.cj.jdbc.result.ResultSetImpl;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.sql.SQLException;
import java.util.*;

@Slf4j
@Service
public class DMUserInformationProcessor extends DataMigrationProcessorService {
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    AdamUserMapper userMapper;
    @Autowired
    AdamUserInfoMapper userInfoMapper;

    public static final String DM_FAILED_USER = "dm:failed:mobile";
    public static final String DM_EXISTS_USER = "dm:exists:mobile";
    public static List<String> reMobileList = new ArrayList<>();
    public static Map<String, AdamTagVo> sexMap = new HashMap<>();
    static {
        sexMap.put("SECRET", AdamTagVo.getNew().setVal("MS00").setDesc("保密"));
        sexMap.put("MALE", AdamTagVo.getNew().setVal("MS01").setDesc("男性"));
        sexMap.put("FEMALE", AdamTagVo.getNew().setVal("MS02").setDesc("女性"));
        reMobileList.addAll(Arrays.asList("13002141406","13002949968","13003920639","13007118272","13008579520","13012739937","13014645041","13015440273","13015944838","13016798655","13017972311","13021058071","13022978691","13027820987","13029923645","13031018197","13034966557","13039931349","13044269525","13051092630","13051188138","13058902388","13060368713","13060399508","13060458210","13060955588","13063066827","13065425188","13076096902","13076476948","13078129279","13080160908","13086074180","13086694451","13102677330","13118506842","13130678375","13131101044","13136133216","13139428881","13144626623","13145821246","13149304200","13150515171","13156587681","13158171218","13158533989","13159557308","13163577553","13167220842","13169782636","13171193333","13172061363","13189099888","13192273705","13193021491","13194881216","13195202935","13197085000","13197471823","13203807310","13207134322","13208647070","13210823609","13211301187","13211693822","13212257237","13219062131","13220517377","13222799825","13225179683","13230325855","13232653681","13240401960","13250971718","13251009023","13251298029","13256399018","13258177625","13258258342","13258273029","13265388935","13268666061","13270165607","13275023883","13275883198","13284686438","13286229964","13286555602","13291832167","13292620033","13305610191","13315577202","13316187458","13324773774","13325940015","13329974936","13336130848","13337623482","13340006212","13340950471","13341610524","13350307172","13350504852","13360726405","13361067510","13361086480","13365048310","13369208854","13370323038","13370863452","13373019712","13373165304","13373858565","13386059626","13389378886","13392110660","13398443131","13402985311","13404992277","13411191500","13411970813","13413040688","13413919470","13415037666","13417022313","13422329562","13426038952","13432568214","13433127001","13433461050","13437169788","13437195565","13437664651","13438913645","13458433995","13466224733","13466490621","13476036922","13476130720","13480358135","13480971152","13481151713","13484149529","13501181434","13501632068","13501707990","13502703207","13507200484","13508819974","13512729128","13516109196","13522156288","13522743883","13523482295","13527999769","13528048997","13530872836","13532490930","13533824309","13536758030","13537864646","13538222901","13538997434","13539342640","13540961290","13541203817","13544170372","13545185067","13546420777","13550070117","13553746350","13554069553","13554197658","13554406295","13555469196","13555622072","13556851156","13557567710","13558777712","13559022113","13559394357","13560424702","13565211119","13567001290","13572858079","13574235365","13574809605","13584826509","13585895003","13586515660","13588336805","13589998613","13590356342","13597300627","13597391163","13600472030","13602773461","13602774398","13606066901","13606118172","13609620784","13609730897","13611709098","13616655991","13619183291","13631561022","13632706189","13632800238","13633197813","13639952063","13641177044","13641708024","13641792735","13646777532","13648055349","13648072031","13648718101","13649297636","13650735350","13658870215","13660003683","13660023300","13660606838","13662333804","13663013028","13664290248","13665730315","13666078581","13666239938","13668261957","13668322197","13675159586","13681091417","13681301585","13681531786","13686666680","13701331419","13701732930","13701814657","13704953889","13705837913","13711660185","13713551329","13713562907","13713749123","13715171853","13716886369","13718975950","13720002304","13723471817","13726348432","13729006882","13730771688","13735528891","13736162504","13738006039","13738337076","13738779623","13759184415","13761043926","13761577398","13761579934","13764111846","13764858765","13766349886","13767167402","13771575208","13776280507","13776605296","13777947962","13778109961","13779695293","13780584044","13788438555","13790063070","13792287300","13793287239","13794460537","13795115537","13795908277","13797166189","13801519998","13801529558","13802553165","13802885215","13806259502","13807801246","13810056286","13810622846","13811397513","13814911780","13815575530","13816806647","13816876258","13816891056","13818393018","13819427399","13823370192","13823529313","13824380415","13824491325","13825776329","13826686921","13828619025","13830344887","13830831009","13835751486","13840052451","13841438265","13843153980","13850960456","13855459306","13856120932","13857663691","13860704330","13861638232","13862829321","13865336985","13866751339","13871293024","13873124455","13877432205","13877610231","13878984481","13879229934","13879872108","13880555474","13881560775","13882083796","13888607355","13898167735","13901357997","13906050534","13906918227","13913448519","13914744921","13915967154","13916862346","13918156052","13918161924","13919876599","13923257274","13925519789","13928792993","13932167925","13933530414","13935192647","13944117787","13946035813","13948067705","13950473676","13952859220","13956064318","13956741825","13957362717","13958117507","13962464710","13970881916","13971288136","13971361833","13973460121","13974331988","13976366476","13978864732","13980995042","13981060568","13984583636","13986233152","13988889259","13990594426","13990898573","13996512635","13999118354","14718112928","14750285676","14769289187","14789306741","15000957595","15003937675","15005189260","15012802590","15013811996","15013839952","15018372099","15021972737","15023424471","15026764125","15029178148","15030405134","15032189312","15033025726","15034158855","15039743945","15044279748","15045062297","15050565458","15052656734","15055455331","15056304837","15058750068","15061232856","15067523105","15067859976","15068155721","15068574770","15071015334","15071413312","15072387870","15072921520","15076332514","15076600063","15077918073","15078833744","15081374937","15083524828","15084696460","15088389039","15090710650","15093807120","15094351707","15095243571","15095887008","15098072310","15099036560","15101102545","15103544288","15107736872","15110797656","15111373723","15111862653","15111931154","15115425560","15115626701","15116733237","15118565343","15121023548","15121471600","15123327484","15124796067","15125015675","15126659443","15129371136","15131267669","15135099611","15135100690","15136180302","15138933729","15148016213","15150665176","15153344349","15155944775","15156545562","15156933890","15158663007","15162245941","15165502922","15171484622","15172016935","15172484529","15174590823","15177731542","15182680868","15183200803","15184424143","15187592115","15188112255","15195762815","15196626783","15198170889","15198261881","15198271450","15201693722","15201763805","15203696362","15205985151","15206338002","15208300423","15210408661","15211825652","15214315853","15216621691","15217388290","15217951060","15219324655","15219850889","15219895497","15220877951","15221686960","15223113848","15223278789","15223768428","15226533358","15229413031","15229864017","15234086868","15236054999","15242408148","15247124507","15253108206","15257219440","15258243352","15258503781","15259011295","15260130079","15260501324","15265815798","15268288905","15268716701","15273850911","15283838291","15290432282","15291902881","15292921692","15294030577","15294632612","15295661198","15296197909","15300908131","15301778818","15313678089","15316310063","15319970635","15330809632","15348012424","15348906327","15352307212","15353689068","15359321348","15362159749","15382320871","15386197858","15386371564","15386642088","15388721845","15389528040","15500022575","15503604220","15510798945","15515862829","15521043864","15521382524","15522607768","15528309572","15536369552","15537171989","15539741030","15543075979","15547765149","15550555410","15553910871","15555661886","15558056509","15559782966","15559790809","15559996254","15571910706","15574165192","15575896758","15581229758","15585643442","15596491909","15601765323","15601965610","15601966671","15608284929","15610166251","15616170380","15618068757","15619240826","15621433797","15621698082","15622377056","15622712714","15623118760","15623150107","15627119375","15627529218","15633126770","15635465932","15637165668","15638351686","15639372680","15651759750","15652867669","15658278631","15658379973","15659803132","15668609854","15668766346","15671609721","15674995242","15679141698","15680500220","15685006388","15687874907","15688596737","15691560018","15695926791","15701573825","15704567000","15711263198","15711344470","15713153196","15714105850","15718352766","15721987094","15723663401","15726626077","15726928821","15735177845","15752285071","15755490797","15756532495","15757862088","15757994129","15759509670","15759742214","15761631029","15763469628","15766631247","15767363367","15768877814","15769681026","15771802754","15772160715","15777608036","15777788639","15799061290","15801072128","15801658959","15801929589","15802076890","15802995095","15809267259","15810125435","15810150232","15810776634","15810800462","15812523155","15816423704","15816824566","15822576130","15823451409","15826007619","15827342658","15827593365","15828205521","15828484182","15829083263","15829940703","15833686795","15834116701","15842411046","15842665912","15847290709","15852928238","15856401245","15857174395","15858850350","15861817962","15862896629","15863880212","15868507975","15871406601","15878564709","15882559032","15885521227","15887150237","15888351788","15891481846","15891777200","15892522181","15892938505","15895061310","15900922892","15901268362","15901577904","15901618989","15905130188","15905263115","15906562035","15909603317","15910633307","15911297339","15914214014","15914927447","15915914941","15918590807","15918901828","15921789523","15926311358","15927107087","15927436498","15928733268","15929958127","15934698735","15941188017","15956939525","15957115520","15957852784","15959306991","15966811068","15966933908","15969583045","15972068848","15972825657","15973670600","15975855787","15977931513","15979076821","15979264161","15982052214","15982626566","15985302639","15985870927","15986715011","15986771927","15988280957","15990035390","15990195044","15992133662","15992224999","16534175133","16607085060","16608631949","16608709624","16620161128","16630352517","16639529387","16670203192","16676595605","16681560957","16687926632","16696101525","17153893782","17302245291","17302701601","17303198637","17308813676","17310542253","17316680977","17317304881","17319211274","17326026287","17326037422","17328751749","17331677599","17336321104","17341539312","17341901316","17350758722","17354206361","17358176920","17358564956","17359283106","17360075078","17361054974","17361055304","17361665848","17361679126","17367078213","17371453817","17380590026","17381578508","17381579522","17392357600","17396230342","17396231540","17396355991","17501626014","17509150806","17521259189","17521781552","17550325652","17551751401","17573410283","17600209311","17600712273","17601230876","17602629330","17603204271","17603426893","17605169863","17607086772","17607136164","17608298893","17609589341","17610903217","17611158702","17611410102","17611606767","17612258540","17612727297","17612747098","17615131566","17620011737","17621507192","17621509998","17623143582","17623235223","17623266982","17623321217","17625133775","17625656484","17628289434","17635638931","17638846432","17642089719","17642196004","17645055794","17649836693","17660846496","17666127342","17670324598","17670613847","17673126890","17673343750","17682163313","17683806308","17684100696","17687173579","17687230104","17688245942","17689419221","17693971907","17694949308","17695427548","17695599638","17699942500","17702295996","17706008603","17706925283","17707659369","17708925439","17712855354","17713554570","17717518129","17717656136","17720797795","17721296197","17721458509","17721497383","17722512139","17725042375","17726967796","17727210197","17727674987","17727700275","17730446630","17731859296","17740530929","17744201216","17751257375","17751968322","17754613037","17757580519","17760895597","17761275296","17762102069","17762880118","17765191320","17765502521","17765995604","17767701830","17770790430","17770825372","17771689945","17771778062","17772378468","17776853889","17782783980","17783310959","17784411631","17784479858","17786030164","17786357524","17786395531","17789185695","17789790017","17791477721","17795171172","17800238060","17803316900","17806641192","17810272328","17815467516","17816096729","17816879495","17817354214","17817995340","17821291015","17826029022","17826266297","17826866731","17838697906","17850391972","17852408908","17853691393","17853981962","17857441522","17858050636","17858379561","17860504340","17863931600","17864279872","17882262040","17889721250","18002255056","18003153692","18008053389","18008188779","18015923219","18018618452","18020228477","18030196487","18030643693","18030873852","18033003992","18033656333","18037551206","18040128560","18043142422","18046568230","18049223435","18050263739","18050586190","18051222000","18060572197","18060689681","18060966152","18061446835","18064303707","18065250015","18066066079","18070291516","18078114674","18080835277","18082493296","18086441979","18087546373","18089191120","18091662876","18092335007","18094714670","18099663833","18101723192","18105168121","18106976990","18107176488","18108617525","18109073231","18117365881","18118000526","18120815309","18123239628","18123862742","18140011103","18148007884","18149077701","18161174572","18161893070","18163510124","18163621756","18163682226","18164893367","18167003217","18168076120","18171276463","18186202626","18186787569","18187271890","18190330280","18190528386","18191332980","18193111731","18193509922","18194103433","18200243648","18200381529","18202073307","18202413752","18205705364","18206091169","18207686414","18210630669","18211208382","18214377737","18214619712","18215590309","18217111781","18217114715","18217349908","18217603029","18217753326","18217770336","18218021225","18218602061","18228063957","18229940710","18235906996","18236729858","18240263608","18241860366","18242049470","18252059919","18252782040","18257155642","18260629082","18267612787","18269263708","18271972389","18273038679","18275291705","18277240342","18280499863","18280505159","18281580262","18281608011","18281636977","18283120421","18285142051","18286202001","18287364552","18287840750","18288287875","18288902748","18289965624","18292932269","18295145093","18300632687","18302035529","18304081416","18306626122","18308404903","18310622996","18310748625","18312022704","18317164673","18317170704","18317187496","18318581594","18321425259","18321613239","18321755702","18321885379","18328326812","18336852678","18346550339","18350786091","18352539736","18355196956","18357506050","18358335449","18359255585","18362382083","18362720817","18366166833","18369482357","18369653203","18380202091","18382256824","18382639068","18384062241","18387630424","18388150749","18388164781","18388255650","18389449062","18389957808","18390869220","18392079408","18392208507","18392359033","18392530677","18393058060","18404636789","18404710190","18405865656","18417162068","18447112882","18482215251","18500397394","18500929585","18502327095","18502750998","18502851677","18506499870","18508466379","18508946661","18509005603","18509299071","18510086959","18511066056","18511300136","18513529246","18513668655","18514490912","18515558599","18516314863","18516609778","18519007073","18519195486","18519265551","18519839597","18520516273","18522354630","18525460377","18525871257","18536479582","18537312789","18538292503","18543169055","18547033455","18549989173","18551033306","18551352796","18553786276","18556979753","18558782096","18561679109","18561993739","18565452625","18568859279","18570570100","18571770903","18573032326","18575232339","18575901873","18576270824","18577850921","18579068268","18583905775","18588407171","18588891343","18591202317","18594229936","18599100721","18600573068","18601340810","18601346035","18603470361","18604020586","18607112606","18607214457","18612081082","18612691281","18617695232","18618490520","18621555306","18622774730","18623335355","18624473427","18627124756","18628063013","18628156083","18628182564","18630609093","18637640613","18642908228","18645146616","18647544111","18649034302","18652422035","18653597113","18656638210","18657199683","18658431528","18659528373","18660371303","18661976561","18662257052","18664604248","18664730413","18670236014","18670795303","18672875727","18674104236","18674473898","18676173486","18676480936","18676960357","18680952820","18682313046","18684754425","18686669176","18686927550","18691832463","18695142796","18695176818","18696569696","18701571142","18705991530","18706816353","18708101330","18708103158","18709681005","18711506069","18711787441","18711789664","18712699918","18717807102","18717838898","18719082935","18720144980","18721895124","18723290373","18724508178","18725400838","18728166555","18728447500","18728607487","18734924967","18739130027","18749055457","18750502299","18751058212","18757160479","18757589373","18758186357","18758603729","18760019877","18763602907","18765203522","18767150363","18767320026","18768332421","18768336108","18771278721","18773646631","18773694865","18776895536","18779108683","18779866869","18780107207","18780906934","18781389308","18783600540","18786776307","18788578952","18788832794","18789012542","18789937601","18792918556","18793190262","18795981906","18800104858","18800385923","18800412830","18804061199","18810003574","18810398789","18810539509","18810616151","18810711800","18810767086","18810908002","18810917160","18810917681","18811514710","18811521016","18811526798","18813080377","18813178711","18813645140","18815600290","18817583080","18817836561","18817920393","18818215701","18818722960","18819253725","18819268659","18819269247","18822901806","18823669085","18824864961","18825007650","18825067549","18826070474","18826135600","18826530633","18827063667","18827431319","18829280974","18829550987","18832437107","18839799091","18842502216","18842921584","18846035229","18846645198","18850205381","18850397052","18850868627","18851191983","18852025089","18852631740","18855062760","18855458438","18856355901","18856996194","18857337896","18858280820","18859569997","18860448098","18862814755","18863366089","18868005075","18868110523","18876628846","18879943511","18883389396","18883920272","18885418909","18888717158","18892051835","18893124569","18895035333","18896953179","18899733023","18900612677","18905101613","18908006663","18908290115","18908483584","18909919578","18911692039","18917110835","18922980823","18923468506","18924557482","18927152931","18936059580","18939011036","18946644181","18950157249","18952373901","18959952359","18960785705","18963937173","18968088279","18971205896","18974289323","18975768043","18976542263","18976705284","18976781790","18977365993","18978681135","18980530614","18980847482","18980956199","18981792312","18983155076","18983649586","18985320933","18986114551","18987476291","18988036926","18990867074","18990950161","18992823792","18996911833","18996987883","19110618718","19129232215","19168673022","19183965216","19525001498","19810851082","19817773025","19822967226","19829069196","19834012060","19850201982","19851044768","19856935972","19861961020","19867583833","19867688086","19906511526","19906653994","19907206757","19909113625","19918649953","19923534285","19924335243","19925741819","19928795647","19933377328","19936079627","19942278253","19943191341","19948075027","19954181046","19983414500"));
    }

    @SneakyThrows
    @Override
    protected void dataProcessing(boolean flg) {
        String sqlCount = "select count(1) from users where delete_tag in (0,1) and length(mobile)=11 ";
        String field = "uid,mobile,username,sex,birthday,area,sign,face_url,back_url,created_at,updated_at,is_complete,rong_cloud_token,rong_cloud_tag";
//                     1-uid,2-mobile,3-username,4-sex,5-birthday,6-area,7-sign,8-face_url,9-back_url,10-created_at,11-updated_at,12-is_complete,13-rong_cloud_token,14-rong_cloud_tag
        String sql = sqlCount.replace("count(1)", field);

        if (flg) {
            sqlCount += "and mobile in ('13753596360','17701223310','18518013286','18548596019','15901093014')";
            sql += " and mobile in ('13753596360','17701223310','18518013286','18548596019','15901093014')";
        }

        sql += " limit ?,?";

        statement = connection.prepareStatement(sqlCount);
        row = (ResultSetImpl) statement.executeQuery();
        row.first();
        int ct = row.getInt(1), pSize = 2, num = 0;
        log.info("DM数据迁移总数:{}", ct);



        while (ct > 0) {
            statement = connection.prepareStatement(sql);
            statement.setInt(1, pSize * num);
            statement.setInt(2, pSize);
            row = (ResultSetImpl) statement.executeQuery();
            log.info("DM.execute.limit:[pNo:{},pSize:{}]", pSize * num, pSize);
            while (row.next()) {
                try {
                    AdamTagVo sex = sexMap.get(row.getString(4));

                    String mobile = row.getString(2);

                    if (!reMobileList.contains(mobile)) {
//                        log.info("mobile:{}", user.getMobile());
                        if (userMapper.selectCount(Wrappers.lambdaQuery(AdamUser.class).eq(AdamUser::getMobile, mobile)) > 0) {
                            redisUtil.lSet(DM_EXISTS_USER, mobile);
                        } else {
                            AdamUser user = new AdamUser();
                            user.setUid(row.getString(1));
                            user.setMobile(mobile);
                            user.setCreatedAt(row.getLocalDateTime(10));
                            user.setUpdatedAt(row.getLocalDateTime(11));
                            user.setState(1);

                            AdamUserInfo userInfo = new AdamUserInfo();
                            userInfo.setUid(user.getUid());
                            userInfo.setNickname(row.getString(3));
                            userInfo.setSex(JsonUtils.toJson(sex));
                            userInfo.setBirthday(row.getLocalDate(5));
                            userInfo.setArea(row.getString(6));
                            userInfo.setSignature(row.getString(7));
                            userInfo.setAvatar(row.getString(8));
                            userInfo.setBackground(row.getString(9));
                            userInfo.setQrCode("lN".concat(userInfo.getUid()).concat(RandomStringUtils.randomAlphanumeric(5).toUpperCase()));
                            userInfo.setRongCloudToken(row.getString(13));
                            userInfo.setRongCloudTag(row.getInt(14));

                            AdamUserInfoVo vo = AdamUserInfoVo.getNew();
                            vo.setUid(user.getUid());
                            vo.setMobile(user.getMobile());
                            vo.setNickname(userInfo.getNickname());
                            vo.setState(user.getState());
                            vo.setSex(sex);
                            vo.setBirthday(DateUtil.Formatter.yyyy_MM_dd.format(userInfo.getBirthday()));
                            vo.setArea(userInfo.getArea());
                            vo.setSignature(userInfo.getSignature());
                            vo.setAvatar(userInfo.getAvatar());
                            vo.setBackground(userInfo.getBackground());
                            vo.setCreateAt(user.getCreatedAt());
                            vo.setUpdatedAt(user.getUpdatedAt());
                            vo.setIsComplete(row.getInt(12));
                            vo.setQrCode(userInfo.getQrCode());

                            userMapper.insert(user);
                            userInfoMapper.insert(userInfo);
                            mongoTemplate.insert(vo, AdamUserInfoVo.class.getSimpleName());
                        }
                    }
                } catch (SQLException throwables) {
                    redisUtil.lSet(DM_FAILED_USER, row.getString(2));
                    log.error("DM数据处理异常[uid:{},mobile:{}],{} - {}", row.getString(1), row.getString(2),
                            throwables.getErrorCode(), throwables.getMessage());
                }
            }


            num++;
            ct -= pSize;
        }
    }
}
