package com.liquidnet.common.third.zxlnft.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 9.企业注册实名接口
 * @class: RegisterCompanyReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:27
 */
@Data
public class Nft009RegisterCompanyReqDto implements Serializable {
    /**
     * 企业名称
     */
    private String epName;
    /**
     * 企业邮箱
     */
    //@Null
    private String email;
    /**
     * 手机验证码
     */
    private String VerifyCode;
    /**
     * 企业信用代码
     */
    private String creditCode;
    /**
     * 营业执照文件标识，通过调用上传接口后获得
     */
    private int busiLicenseId;
    /**
     * 电子公函盖章扫描件标识，通过调用上传接口后获得
     */
    //@Null
    private int officialLetterId;
    /**
     * 法人代表姓名
     */
    private String representativeName;
    /**
     * 管理员姓名
     */
    private String contact;
    /**
     * 管理员手机
     */
    private String mobile;
    /**
     * 管理员身份证号
     */
    private String idcard;
    /**
     * 证件类型 1-身份证 2-护照 3-港澳通行证 4-台湾通行证 5-外国人永居身份证 6-港澳台居民居住证 7-其它
     */
    private int cardType;
    /**
     * 接入平台名称
     */
    //@Null
    private String platformName;
    /**
     * 接入平台地址
     */
    //@Null
    private String platformUrl;
    /**
     * 平台业务类型（1:金融类 2:版权类 3:其他类 4:未填写）默认是未填写
     */
    //@Null
    private int businessType;

    private static final Nft009RegisterCompanyReqDto obj = new Nft009RegisterCompanyReqDto();
    private static final long serialVersionUID = 6822986751743429155L;

    public static Nft009RegisterCompanyReqDto getNew() {
        try {
            return (Nft009RegisterCompanyReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft009RegisterCompanyReqDto();
        }
    }
}
