package com.liquidnet.service.goblin.dto.manage;

import com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@ApiModel(value = "GoblinStoreMgtCompleteParam", description = "店铺认证:认证资料入参")
@Data
public class GoblinStoreMgtCompleteParam implements java.io.Serializable {
    private static final long serialVersionUID = -5612313562282544613L;
    @ApiModelProperty(position = 11, value = "店铺名称[128]", example = "店铺名称...")
    @Size(max = 128, message = "店铺名称过长")
    private String storeName;
    @ApiModelProperty(position = 12, value = "店铺LOGO[256]", example = "https://img.zhengzai.tv/files/2020/08/31/5f4c75095e9bc.png")
    @Size(max = 256, message = "店铺LOGOURL过长")
    private String logoPic;
    @ApiModelProperty(position = 13, value = "店铺背景图[256]", example = "http://pic.zhengzai.tv/202201/CC/BF/1641361220_C8648990308E1C77247CCA0A37B68F07.jpg")
    @Size(max = 256, message = "店铺背景图URL过长")
    private String backgroundPic;
    @ApiModelProperty(position = 14, value = "店铺介绍[1000]", example = "店铺介绍......")
    @Size(max = 2000, message = "店铺介绍内容过长")
    private String introduce;
    @ApiModelProperty(position = 15, value = "店铺类型[1-普通店铺|2-加盟|3-连锁|5-直营]", allowableValues = "1,2,3,5", example = "1")
    @Pattern(regexp = "\\b(1|2|3|5)\\b", message = "店铺类型参数无效")
    private String storeType;

    public GoblinStoreInfoVo completeStoreInfoVo(GoblinStoreInfoVo vo) {
        vo.setStoreName(this.getStoreName());
        vo.setLogoPic(this.getLogoPic());
        vo.setBackgroundPic(this.getBackgroundPic());
        vo.setIntroduce(this.getIntroduce());
        vo.setReason("");
        vo.setStatus("1");
        vo.setStoreType(StringUtils.isNotBlank(this.getStoreType()) ? this.getStoreType() : "1");
        return vo;
    }
}