package com.liquidnet.common.swagger.dto;

import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 多服务接口分级统计数据传输对象
 * 
 * @author system
 * @since 2024-10-30
 */
@Data
public class MultiServiceStatisticsDto {
    
    /**
     * 所有服务的总接口数
     */
    private Integer totalCount;
    
    /**
     * 所有服务汇总的级别统计 (级别名称 -> 数量)
     */
    private Map<String, Integer> totalLevelStatistics;
    
    /**
     * 各服务的统计信息列表
     */
    private List<ServiceStatistics> serviceStatistics;
    
    /**
     * 服务健康状态 (服务名称 -> 是否健康)
     */
    private Map<String, Boolean> serviceHealth;
    
    /**
     * 单个服务的统计信息
     */
    @Data
    public static class ServiceStatistics {
        /**
         * 服务名称
         */
        private String serviceName;
        
        /**
         * 服务是否健康
         */
        private Boolean isHealthy;
        
        /**
         * 该服务的完整统计数据
         */
        private ApiLevelStatisticsDto statistics;
    }
}