package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 失物招领管理员实体类
 *
 * @author liquidnet
 * @since 2025-01-18
 */
@ApiModel("失物招领管理员")
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetLostFoundAdmin implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键ID")
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @ApiModelProperty("管理员ID")
    private String adminId;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("备注姓名")
    private String name;

    @ApiModelProperty("权限类型：1-发帖员(仅发帖,发布后不可编辑) 2-管理员(发帖、编辑、删除)")
    private Integer permissionType;

    @ApiModelProperty("授权范围：1-本站次 2-全站")
    private Integer authScope;

    @ApiModelProperty("演出ID")
    private String performanceId;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("是否删除：0-未删除 1-已删除")
    private Integer isDeleted;


    private static final SweetLostFoundAdmin obj = new SweetLostFoundAdmin();

    public static SweetLostFoundAdmin getNew() {
        try {
            return (SweetLostFoundAdmin) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetLostFoundAdmin();
        }
    }

    // 权限类型枚举
    public enum PermissionType {
        POSTER(1, "发帖员"),
        ADMIN(2, "管理员");

        private final int code;
        private final String desc;

        PermissionType(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public int getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }
    }

    // 授权范围枚举
    public enum AuthScope {
        CURRENT_EVENT(1, "本站次"),
        ALL_EVENTS(2, "全站");

        private final int code;
        private final String desc;

        AuthScope(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public int getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }
    }

}