package com.liquidnet.service.chime.vo.mongo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ChimeUserTagsMappingVo
 * @Package com.liquidnet.service.chime.vo.mongo
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/3 16:50
 */
@ApiModel(value = "ChimeUserInfoVo", description = "社交用户信息")
@Data
public class ChimeUserInfoVo {
    private String mid;
    private static final long serialVersionUID = 5325511589667456213L;
    @ApiModelProperty(position = 0, value = "用户ID[64]")
    private String userId;
    @ApiModelProperty(position = 1, value = "性别")
    private String sex;
    @ApiModelProperty(position = 8, value = "在场ID")
    private String joinPerformanceId;
    @ApiModelProperty(position = 8, value = "是否在场")
    private Boolean isOnLine;
    @ApiModelProperty(position = 9,value = "用户标签")
    private List<ChimeUserTagsMappingVo> userTagsVoList;
    @ApiModelProperty(position = 15, value = "创建时间")
    private String createdAt;
    @ApiModelProperty(position = 15, value = "更新时间")
    private String updatedAt;
    @ApiModelProperty(position = 10, value = "喜欢操作")
    private long likeCount;
    @ApiModelProperty(position = 11, value = "不喜欢操作")
    private long disLikeCount;
    @ApiModelProperty(position = 10, value = "点击喜欢操作")
    private long clickLikeCount;
    @ApiModelProperty(position = 11, value = "点击不喜欢操作")
    private long clickDisLikeCount;

    private static final ChimeUserInfoVo obj = new ChimeUserInfoVo();
    public static ChimeUserInfoVo getNew() {
        try {
            return (ChimeUserInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new ChimeUserInfoVo();
        }
    }
}
