package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

import static com.liquidnet.commons.lang.util.DateUtil.DTF_YMD_HMS;

/**
 * <p>
 * 订单退单退款表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinBackOrderDetailsVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "订单退单表id")
    private String backOrderId;
    @ApiModelProperty(value = "退款单号")
    private String backCode;
    @ApiModelProperty(value = "订单id")
    private String orderId;
    @ApiModelProperty(value = "订单编号")
    private String orderCode;
    @ApiModelProperty(value = "商铺id")
    private String storeId;
    @ApiModelProperty(value = "用户id")
    private String userId;
    @ApiModelProperty(value = "退款sku")
    private List<GoblinBackOrderSkuVo> backOrderSkuVos;
    @ApiModelProperty(value = "类型[1-退款|2-退货]")
    private Integer type;
    @ApiModelProperty(value = "退款／退货原因[1-不想买了|2-收货人信息有误|3-未按指定时间发货|4-其他|5-不想买了|6-商品质量问题|7-收到商品与描述不符|8-商铺发起|9-系统自动申请]")
    private String reason;
    @ApiModelProperty(value = "问题说明")
    private String describes;
    @ApiModelProperty(value = "返回方式[1-快递返回]目前只有快递返回 （退货的时候用户给商城寄送商品）")
    private Integer backType;
    @ApiModelProperty(value = "退货时候实际退款金额")
    private BigDecimal realBackPrice;
    @ApiModelProperty(value = "快递费退款金额(包含在realBackPrice内)")
    private BigDecimal backPriceExpress;
    @ApiModelProperty(value = "上传的退款凭证或者质检发票 多个图片 用, 隔开")
    private String pics;
    @ApiModelProperty(value = "退款／退货状态[0-商铺发起退款|1-退款申请(用户发送退款请求)|2-退款成功(商家同意退款)|3-退款拒绝(商家拒绝退款)|4-退货申请(用户发起退货请求)|5-退货拒绝(商家拒绝退货)|6-退货审核通过等待用户填写物流(商家审核通过，等待用户寄回商品)|7-待收货(用户已确认)|8-退货完成(商家收货并且同意退款给用户)|9-退货失败(商家不同意退款)")
    private Integer status;
    @ApiModelProperty(value = "物流公司名称")
    private String logisCompanyName;
    @ApiModelProperty(value = "物流单号")
    private String mailNo;
    @ApiModelProperty(value = "退款时间")
    private String refundAt;
    @ApiModelProperty(value = "审核时间")
    private String auditAt;
    @ApiModelProperty(value = "创建时间")
    private String createdAt;
    @ApiModelProperty(value = "过期时间")
    private String expireAt;
    @ApiModelProperty(value = "拒绝时间")
    private String RefuseAt;

    @ApiModelProperty(value = "支付时间")
    private String payTime;
    @ApiModelProperty(value = "优惠金额")
    private BigDecimal priceVoucher;
    @ApiModelProperty(value = "快递金额")
    private BigDecimal priceExpress;
    @ApiModelProperty(value = "实付金额")
    private BigDecimal priceActual;
    @ApiModelProperty(value = "是否会员")
    private int isMember;
    @ApiModelProperty(value = "下单时用户昵称")
    private String userName;
    @ApiModelProperty(value = "下单时手机号")
    private String userMobile;
    @ApiModelProperty(value = " 活动名称")
    private String marketName;
    @ApiModelProperty(value = "订单SkuVo")
    List<GoblinOrderSkuVo> orderSkuVoList;

    private static final GoblinBackOrderDetailsVo obj = new GoblinBackOrderDetailsVo();

    public static GoblinBackOrderDetailsVo getNew() {
        try {
            return (GoblinBackOrderDetailsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new GoblinBackOrderDetailsVo();
    }
}
