package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 商品单品扩展信息
 * </p>
 *
 * @author liquidnet
 * @since 2022-05-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinGoodsSkuExtra implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    private String skuId;

    /**
     * 单品AR文件URL-iOS版
     */
    private String arUrlIos;

    /**
     * 单品AR文件URL-android版
     */
    private String arUrlAndroid;

    /**
     * 删除标记[0-未删除|1删除]
     */
    private String delFlg;

    private String createdBy;

    private LocalDateTime createdAt;

    private String updatedBy;

    private LocalDateTime updatedAt;

    private String deletedBy;

    private LocalDateTime deletedAt;

    private String comment;


}
