package com.liquidnet.client.admin.zhengzai.kylin.utils;

import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketTimesVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoClient;
import com.taobao.api.request.AlibabaDamaiMevOpenWithdrawticketRequest;
import com.taobao.api.response.AlibabaDamaiMevOpenWithdrawticketResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Slf4j
public class TaobaoTicketUtils {

    private String URL = "http://gw.api.taobao.com/router/rest";
    private String APPKEY = "27542597";
    private String SECRET = "900025efc616fd2446344bb8fa21d039";
    private String SUPPLIER_SECRET = "444d0752439f921a75eaf5951a8bc03c";
    private Long SYSTEM_ID = 15669L;
    //    private String url = "http://gw.api.tbsandbox.com/router/rest";
//    private String appkey = "4272";
//    private String secret = "0ebbcccfee18d7ad1aebc5b135ffa906";
    private TaobaoClient client = null;

    public TaobaoClient initTaobaoClient() {
        if (client == null) {
            client = new DefaultTaobaoClient(URL, APPKEY, SECRET);
        }
        return client;
    }

    public String getSupplierSecret() {
        return SUPPLIER_SECRET;
    }

    public Long getSystemId() {
        return SYSTEM_ID;
    }

    /**
     * @param timesId         场次的id
     * @param orderEntitiesId 入场人的id
     * @return
     */
    public boolean withdrawDamaiOrder(long timesId, long orderEntitiesId) {
        try {
            TaobaoClient client = initTaobaoClient();
            AlibabaDamaiMevOpenWithdrawticketRequest req = new AlibabaDamaiMevOpenWithdrawticketRequest();
            AlibabaDamaiMevOpenWithdrawticketRequest.TicketIdOpenParam obj1 = new AlibabaDamaiMevOpenWithdrawticketRequest.TicketIdOpenParam();
            obj1.setPerformId(timesId);//场次id
            obj1.setVoucherId(orderEntitiesId);//票单号 入场人id
            obj1.setSupplierSecret(SUPPLIER_SECRET);
            obj1.setSystemId(SYSTEM_ID);
            req.setTicketIdOpenParam(obj1);
            AlibabaDamaiMevOpenWithdrawticketResponse rsp = client.execute(req);
            return rsp.getResult().getSuccess();
        } catch (Exception e) {
            return false;
        }
    }


    public boolean refundDamaiOrder(KylinOrderTicketVo orderData, KylinPerformanceVo vo) {
        try {
            int isSysDamai = 0;
            for (int x = 0; x < vo.getTicketTimeList().size(); x++) {
                KylinTicketTimesVo timeItem = vo.getTicketTimeList().get(x);
                for (int y = 0; y < timeItem.getTicketList().size(); y++) {
                    KylinTicketVo ticketItem = timeItem.getTicketList().get(y);
                    if (ticketItem.getTicketsId().equals(orderData.getTicketId())) {
                        isSysDamai = ticketItem.getSysDamai();
                        break;
                    }
                }
            }
            if (isSysDamai == 1) {
                List<KylinOrderTicketEntitiesVo> listData = orderData.getEntitiesVoList();
                for (int i = 0; i < listData.size(); i++) {
                    KylinOrderTicketEntitiesVo item = listData.get(i);
                    long ticketTimesKey;
                    if (item.getTicketId().length() > 13) {
                        ticketTimesKey = Long.valueOf(IDGenerator.getDamaiCode(item.getTimeId()));
                    } else {
                        ticketTimesKey = Long.parseLong(item.getTimeId());
                    }

                    long orderTicketEntitiesKey;
//                    if (item.getOrderTicketEntitiesId().length() > 13) {
//                        orderTicketEntitiesKey = Long.valueOf(IDGenerator.getDamaiCode(item.getOrderTicketEntitiesId()));
//                    } else {
//                        orderTicketEntitiesKey = Long.valueOf(item.getOrderTicketEntitiesId());//票单号 入场人id
//                    }
                    if (orderData.getIsMember() == 1) {
                        orderTicketEntitiesKey = Long.valueOf(IDGenerator.getDamaiCode(item.getOrderTicketEntitiesId()).toString().concat("010"));
                    } else {
                        orderTicketEntitiesKey = Long.valueOf(IDGenerator.getDamaiCode(item.getOrderTicketEntitiesId()).toString().concat("020"));
                    }
                    if (item.getIsPayment() == 2) {
                        withdrawDamaiOrder(ticketTimesKey, orderTicketEntitiesKey);
                    }
                }
                return true;
            }
            return true;
        } catch (Exception e) {
            log.info("REFUND DAMAI ERROR = {}", e);
            return false;
        }
    }
}
