<?php
/**
 * Created by PhpStorm.
 * User: color
 * Date: 2018/7/19
 * Time: 下午1:58
 */

namespace App\Http\Controllers;


use App\Models\Tag;
use App\Models\Video;
use App\Repositories\HttpRepository;
use Illuminate\Http\Request;
use function json_decode;

class ShareController extends Controller
{

    /**
     * 分享到微博地址
     * @param Request $request
     * @return mixed
     */
    public function shareToWb(Request $request)
    {
        $url = $request->input('url');
//        $url = 'http://wap.zhengzai.tv/pages/video5.0/backVideo.html?vbreId=13501';
        $videoId = $this->checkUrl($url);
        if (!$videoId) {
            return 'error';
        }

        $video = Video::find($videoId);

        $hdUrl = '';
        $sdUrl = '';

        $result = [];

        $streamIds = explode(',', $video['source']);
        $resultPlay = [];

        if (count($streamIds) > 0) {

            $param = [
                'streamId' => $streamIds[0]
            ];
            $resultPlay = HttpRepository::postCurl($param, 'http://appindex.zhengzai.tv/api/getPlaySet');
            $resultPlay = json_decode($resultPlay, true);
            $resultPlay = $resultPlay['data'];
        }

        if (!$resultPlay) {
            return null;
        }

        foreach ($resultPlay as $play) {
            $height = $play['vheight'];
            $width = $play['vwidth'];

            if ($height && $width) {
                if ($height == '720' && $width == '1280') {
                    $hdUrl = $play['url'];
                }
                if ($height == '360' && $width == '640') {
                    $sdUrl = $play['url'];
                }
            }
        }

        //标签
        $tags = Tag::select('name')
            ->whereIn('id', explode(',', $video['video_tags']))
            ->get();
        foreach ($tags as $tag) {
            $result['tags'][] = array('display_name' => $tag['name']);
        }

        $result['display_name'] = $video['video_name'];
        $result['summary'] = $video['video_desc'];
        $result['create_at'] = date('Y-m-d', $video['created_at']);
        $result['url'] = $url;
        $result['titles'] = array([
            'title' => $video['video_name'],
            'default' => ''
        ]);

        $result['stream']['duration'] = $video['video_duration'];
        $result['stream']['hd_url'] = $hdUrl;
        $result['stream']['format'] = 'mp4';
        $result['stream']['url'] = $sdUrl;

        $result['embed_code'] = $hdUrl;

        $result['image']['height'] = '688';
        $result['image']['width'] = '1405';
        $result['image']['url'] = $video['video_pic'];

        //自定义数据
        $result['custom_data']['song'] = '';
        $result['custom_data']['source'] = '正在现场';
        $result['custom_data']['singer'] = '';
        //创建人
        $result['author']['object_type'] = '';
        $result['author']['display_name'] = '';
        $result['author']['url'] = '';
        //links
        $result['links']['url'] = $url;
        $result['links']['scheme'] = '';
        $result['links']['display_name'] = '查看更多';

        return $result;
    }

    private function checkUrl($url)
    {
        if (mberegi("(https?|ftp|file|http)://[-A-Za-z0-9+&@#/%?=~_|!:,.;]+[-A-Za-z0-9+&@#/%=~_|]", $url)) {
            $paramStr = substr($url, strpos($url, '?') + 1);
            $paramArr = explode('&', $paramStr);
            foreach ($paramArr as $item) {
                $param = explode('=', $item);
                if (in_array('vbreId', $param)) {
                    return $param[1];
                }
            }
            return null;

        } else {
            return null;
        }
    }

}