<?php
/**
 * Created by PhpStorm.
 * User: color
 * Date: 2018/1/30
 * Time: 下午7:21
 */

namespace App\Models;

use App\Repositories\TencentVideoRepository;
use function explode;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * 视频model
 * Class Video
 * @package App\Models
 */
class Video extends Base
{
    use SoftDeletes;

    protected $table = 'videos';

    public $timestamps = true;

    protected $fillable = [
        'id', 'video_name', 'video_desc', 'video_pic', 'video_tags', 'video_type', 'video_duration',
        'stage_names', 'begin_time', 'end_time', 'source', 'creator', 'creator_name', 'is_record', 'play_count',
        'playbill', 'is_portrait', 'is_pay', 'video_style', 'lyric', 'thumbnail', 'area_id', 'is_playback',
        'playlist_id', 'chatroom_id', 'is_display', 'status', 'channel_id', 'is_download', 'sorting', 'created_at', 'updated_at',
        'weighting_play_count', 'expect_play_count', 'expect_play_count_time', 'expect_online_count', 'expect_online_count_time', 'weighting_online_count',
        'is_disconnection'
    ];

    protected $guarded = [];

    protected $hidden = [
        'id', 'deleted_at'
    ];

    protected $appends = [
        'video_id'
    ];

    /**
     * @return array
     */
    public function getTagsAttribute()
    {
        $value = $this->video_tags;
        if ($value) {
            $tags = Tag::select('id as tag_id', 'name')->whereIn('id', explode(',', $value))
                ->get();
            return $tags;
        }
        return [];
    }

    public function getVideoIdAttribute()
    {
        return $this->id;
    }

    /**
     * @return mixed
     */
    public function getVideoUrlAttribute()
    {
        $source = $this->source;
        if ($source) {
            $data = TencentVideoRepository::getVideoUrl($source);
            if ($data) {
                $url = $data['playSet'][0]['url'];
                return $url;
            }
        }
        return '';
    }

    /**
     * Rewrite the date to time
     * @param $value
     * @return mixed
     */
    public function getBeginTimeAttribute($value)
    {
        if ($value) {
            return strtotime($value);
        }
        return null;
    }

    /**
     * Rewrite the date to time
     * @param $value
     * @return mixed
     */
    public function getEndTimeAttribute($value)
    {
        if ($value) {
            return strtotime($value);
        }
        return null;
    }

    public function getIsPortraitAttribute($value)
    {
        if ($value) {
            return $value;
        }
        return 0;
    }
}