<?php
/**
 * Created by PhpStorm.
 * User: color
 * Date: 2018/2/2
 * Time: 上午10:29
 */

namespace App\Repositories;


class HttpRepository
{
    /**
     * post请求
     * @param $post_data string
     * @param $url
     * @param int $second
     * @return bool|mixed
     */
    public static function postCurl($post_data, $url, $second = 0)
    {
        //初始化curl
        $ch = curl_init();
        //超时时间
        curl_setopt($ch, CURLOPT_TIMEOUT, $second);
        //这里设置代理，如果有的话
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        //设置header
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        //要求结果为字符串且输出到屏幕上
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        //post提交方式
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
        //运行curl
        $data = curl_exec($ch);
        //返回结果
        if ($data) {
            curl_close($ch);
            return $data;
        } else {
            $error = curl_errno($ch);
            curl_close($ch);
            return false;
        }
    }

    /**
     * get请求
     * @param $url
     * @param int $second
     * @return bool|mixed
     */
    public static function getCurl($url, $second = 0)
    {
        //初始化curl
        $ch = curl_init();
        //超时时间
        curl_setopt($ch, CURLOPT_TIMEOUT, $second);
        //这里设置代理，如果有的话
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        //设置header
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        //要求结果为字符串且输出到屏幕上
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        //运行curl
        $data = curl_exec($ch);
        //返回结果
        if ($data) {
            curl_close($ch);
            return $data;
        } else {
            $error = curl_errno($ch);
            curl_close($ch);
            return false;
        }
    }

    /**
     * 设置聊天室id
     * @param $chatRoomId
     * @param $liveId
     * @param $videoId
     * @param $videoName
     */
    public static function setChatRoomId($chatRoomId, $liveId, $videoId, $videoName)
    {
        $url = "http://118.190.131.107:8181/api/open/media/createChatroom";
        $param = [
            'liveId' => $liveId,
            'videoId' => $videoId,
            'videoName' => $videoName,
            'chatroomId' => $chatRoomId
        ];
        $sign = SignRepository::createSign($param);
        $param['signature'] = $sign;

        HttpRepository::postCurl($param, $url);

    }

}